/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMResourceSelectionDialog;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMRoleNameEditor;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMSelectedResourcesTableModel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWSIMResourceAllocationPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWSIMPropertyChangeListener {
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_selectedResourcesTable = null;
    private VWSIMSelectedResourcesTableModel m_selectedResourcesTableModel = null;
    private VWSIMResourceSelectionDialog m_resourceSelectionDialog = null;
    private VWScenarioShiftDefinition m_shiftDefinition = null;
    private VWSIMPropertyData m_propertyData = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.createControls();
        this.setEnabled(false);
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void setShiftDefinition(VWScenarioShiftDefinition shiftDef) {
        this.m_shiftDefinition = shiftDef;
        if (this.m_selectedResourcesTable != null && this.m_selectedResourcesTableModel != null) {
            try {
                this.m_selectedResourcesTable.stopEditing();
                this.m_selectedResourcesTableModel.reinitialize(shiftDef);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            this.m_selectedResourcesTable.clearSelection();
            if (this.m_selectedResourcesTableModel.getRowCount() > 0) {
                this.m_selectedResourcesTable.setRowSelectionInterval(0, 0);
            }
        }
        this.setEnabled(shiftDef != null);
    }

    public void setEnabled(boolean bEnable) {
        if (this.m_toolBarBorder != null) {
            if (bEnable) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 32));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            }
        }
        if (this.m_selectedResourcesTable != null) {
            this.m_selectedResourcesTable.setEnabled(bEnable);
        }
        super.setEnabled(bEnable);
    }

    public void releaseReferences() {
        this.m_toolBarBorder = null;
        this.m_selectedResourcesTable = null;
        this.m_selectedResourcesTableModel = null;
        this.m_resourceSelectionDialog = null;
        this.m_propertyData = null;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_selectedResourcesTable.getSelectedRow()) {
                    this.m_selectedResourcesTable.clearSelection();
                }
                if (nRow >= 0 && this.m_selectedResourcesTableModel.getRowCount() > 0) {
                    this.m_selectedResourcesTable.setRowSelectionInterval(nRow, nRow);
                    break;
                }
                this.updateControlStates();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.updateControlStates();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 32: {
                    this.selectResources();
                    break;
                }
                case 0x10000000: {
                    int nRowIndex = this.m_selectedResourcesTable.getSelectedRow();
                    if (nRowIndex == -1) {
                        return;
                    }
                    this.m_selectedResourcesTableModel.deleteItem(nRowIndex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        if (event.getSource() == this.m_selectedResourcesTableModel) {
            return;
        }
        switch (event.getID()) {
            case 103: {
                if (this.m_selectedResourcesTable == null) break;
                this.m_selectedResourcesTable.stopEditing();
                break;
            }
            case 106: 
            case 116: 
            case 117: {
                if (this.m_shiftDefinition == null) break;
                this.handleUpdatedShift(this.m_shiftDefinition.getName());
                break;
            }
            case 122: {
                if (this.m_shiftDefinition == null || event.getParam() == null) break;
                String[] names = (String[])event.getParam();
                this.handleUpdatedShift(names[1]);
                break;
            }
            case 123: {
                if (this.m_shiftDefinition == null || event.getParam() == null) break;
                String name = null;
                if (event.getParam() instanceof String) {
                    name = (String)event.getParam();
                } else if (event.getParam() instanceof VWScenarioShiftDefinition) {
                    name = ((VWScenarioShiftDefinition)event.getParam()).getName();
                }
                if (name == null) break;
                this.handleUpdatedShift(name);
            }
        }
    }

    private void createControls() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout());
            this.m_toolBarBorder = new VWToolbarBorder(VWSIMResource.s_assignedResources, 0x10000020);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolBarBorder, "Center");
            this.createTable();
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_selectedResourcesTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createTable() {
        TableColumn tcElement = null;
        this.m_selectedResourcesTableModel = new VWSIMSelectedResourcesTableModel(this.m_propertyData);
        this.m_selectedResourcesTableModel.addTableModelListener(this);
        this.m_selectedResourcesTable = new VWTable(this.m_selectedResourcesTableModel);
        this.m_selectedResourcesTable.setRowSelectionAllowed(true);
        this.m_selectedResourcesTable.getSelectionModel().addListSelectionListener(this);
        this.m_selectedResourcesTable.getSelectionModel().setSelectionMode(0);
        this.m_selectedResourcesTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_selectedResourcesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 4));
        tcElement = this.m_selectedResourcesTable.getColumnModel().getColumn(1);
        if (tcElement != null) {
            tcElement.setCellEditor(new VWSIMRoleNameEditor(this.m_selectedResourcesTableModel));
        }
    }

    private void selectResources() {
        try {
            if (this.m_selectedResourcesTableModel != null) {
                if (this.m_resourceSelectionDialog == null) {
                    this.m_resourceSelectionDialog = new VWSIMResourceSelectionDialog(this.m_propertyData);
                }
                String[] selectedResourceNames = this.m_selectedResourcesTableModel.getSelectedResourceNames();
                this.m_resourceSelectionDialog.initialize(selectedResourceNames);
                this.m_resourceSelectionDialog.show();
                if (this.m_resourceSelectionDialog.getExitStatus() == 0) {
                    selectedResourceNames = this.m_resourceSelectionDialog.getSelectedResourceNames();
                    this.m_selectedResourcesTableModel.updateResourceSelection(selectedResourceNames);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void handleUpdatedShift(String shiftName) {
        if (shiftName != null && shiftName.length() > 0 && VWStringUtils.compare(shiftName, this.m_shiftDefinition.getName()) == 0) {
            int nSelectedRow = this.m_selectedResourcesTable.getSelectedRow();
            this.setShiftDefinition(this.m_shiftDefinition);
            if (nSelectedRow != -1 && this.m_selectedResourcesTableModel.getRowCount() > nSelectedRow) {
                this.m_selectedResourcesTable.setRowSelectionInterval(nSelectedRow, nSelectedRow);
            }
        }
    }

    private void updateControlStates() {
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
        int nRowIndex = this.m_selectedResourcesTable.getSelectedRow();
        if (nRowIndex != -1) {
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, Integer.MAX_VALUE));
        }
    }
}

